#include <coleco.h>
#include <getput1.h>

extern byte PATTERNRLE[];
extern byte COLORRLE[];

byte space_pattern[]={0xfe,0xfe,0xfe,0,0xef,0xef,0xef,0};
byte space_grf[8]; /* to be the space pattern in RAM */

typedef struct
{
    char x; /* coor. x */
    char y; /* coor. y */
    char dx; /* delta x */
    char dy; /* delta y */
}    ball_strct;
ball_strct ball;

typedef struct
{
    char x; /* coor. x */
    char y; /* coor. y */
    byte size; /* size */
}    paddle_strct;
paddle_strct paddle;

byte number_of_bricks;

int score;
int hiscore;

byte game_speed;

/* init_graphics function */
void init_graphics()
{
    screen_mode_2_text();
    load_patternrle(PATTERNRLE);
    load_colorrle(COLORRLE);
    upload_default_ascii(BOLD);
    fill_color(33,0xf0,96);
    memcpy(space_grf,space_pattern,8);
    change_pattern(32,space_grf,1);
    fill_color(32,0x60,1);
}    

void space_scroll()
{
 byte i;
 if (ball.dy!=1)
 {
     i = space_grf[7];
     memcpyf (space_grf+1,space_grf,7);
     space_grf[0] = i;
 }
 else
 {
     i = space_grf[0];
     memcpyb (space_grf,space_grf+1,7);
     space_grf[7]=i;
 }    
 change_pattern(32,space_grf,1);
}
 
void initialize()
{
    ball.x=6; /* coor. x=6 */
    ball.y=11; /* coor. y=11 */
    ball.dx=1; /* moving to the right */
    ball.dy=1; /* moving to the bottom */
    paddle.x=15; /* coor. x=15 */
    paddle.y=22; /* coor. y=22 */
    paddle.size=4; /* size=4 */
    number_of_bricks=0;
    score=0;
}

void add_bricks()
{
    char x,y;
    disable_nmi();
    cls();
    for (y=2;y<8;y++)
    {
        for (x=2;x<29;x+=2)
        {
            put_char(x,y,6);
            put_char(x+1,y,7);
            number_of_bricks++;
        }
    }
}    

void show_ball()
{
    put_char(ball.x, ball.y, 1);
}

void erase_ball()
{
    put_char(ball.x, ball.y, 32);
}

void show_paddle()
{
    put_char(paddle.x, paddle.y, 2);
    put_char(paddle.x+1, paddle.y, 3);
    put_char(paddle.x+2, paddle.y, 3);
    put_char(paddle.x+3, paddle.y, 4);
}    

/*
char paddle_str[]={2,3,3,4};
    
void show_paddle()
{
    put_at(paddle.x, paddle.y, paddle_str, 4);
}
*/

void erase_paddle()
{
    print_at(paddle.x, paddle.y, "    ");
}    

void update_ball_position()
{
    ball.x = ball.x + ball.dx;
    ball.y = ball.y + ball.dy;
}

void rebound_on_screen_border()
{
    if (ball.y==0) { pop(); ball.dy=1; }
    if (ball.x==0) { pop(); ball.dx=1; }
    if (ball.x==31) { pop(); ball.dx=-1; }
}    

void rebound_on_paddle()
{
    if (ball.y==paddle.y-1)
    {
        if (ball.x>=paddle.x && ball.x<paddle.x+paddle.size)
        {
            pop(); ball.dy=-1;
        }
        else
        {
            byte x = ball.x + ball.dx;
            if (x==paddle.x)
            {
                if (x!=0) ball.dx=-1;
                pop(); ball.dy=-1;
            }
            if (x==paddle.x+paddle.size-1)
            {
                if (x!=31) ball.dx=1;
                pop(); ball.dy=-1;
            }        
        }
    }           
}

void rebound_on_brick()
{
    char c;
    c = get_char(ball.x, ball.y);
    if (c==6 || c==7)
    {
        pop2(); ball.dy=-ball.dy;
        number_of_bricks--; score++;
        put_char(ball.x+13-(c<<1),ball.y,32);
        paper(c-4);
    }
    else paper(1);           
}

void update_ball_direction()
{
    rebound_on_screen_border();
    rebound_on_paddle();
}

void update_paddle_position()
{
    byte x = paddle.x;
    if (joypad_1&LEFT)
    {
        if (x!=0)
        {
            /* Can't move over the ball */
            if (ball.y!=paddle.y || ball.x!=x) x--;
        }        
    }    
    if (joypad_1&RIGHT)
    {
        if (x+paddle.size!=32)
        {
            /* Can't move over the ball */
            if (ball.y!=paddle.y || ball.x!=x+paddle.size-1) x++;
        }        
    }
    paddle.x=x;
}            

void game_delay()
{
    enable_nmi();
    delay(game_speed);
    disable_nmi();
    space_scroll();
}

void game_engine()
{    
    while (ball.y!=23)
    {
        erase_paddle();
        update_paddle_position();
        show_paddle();
        erase_ball();
        if (number_of_bricks==0) add_bricks(); /* add bricks on screen */
        update_ball_direction();
        update_ball_position();
        rebound_on_brick();
        show_ball();
        game_delay();
        erase_paddle();
        update_paddle_position();
        show_paddle();
        game_delay();
    }        
}    

void game_over()
{
    shoot();
    center_string(11,"GAME  OVER");
    center_string(13,str(score));
    if (score>hiscore)
    {
        center_string(15,"OLD HI-SCORE");
        center_string(17,str(hiscore));
        hiscore=score;
    }
    else
    {
        center_string(15,"HI-SCORE");
        center_string(17,str(hiscore));
    }        
    enable_nmi();
    pause();
    disable_nmi();
}

void menu()
{
    cls();
    center_string(2,"S M A S H");
    center_string(5,"SELECT GAME SPEED");
    center_string(7,"(1=FAST,4=SLOW)");
    enable_nmi();    
    game_speed=choice_keypad_1(1,4);
    disable_nmi();
}    
    
/* main function */
void main()
{
    init_graphics(); /* init. graphics */
    hiscore=0; /* reset hiscore */
restart:
    menu(); /* show menu */
    initialize(); /* init. ball & paddle */
    game_engine(); /* play game */
    game_over(); /* print "game over" */
    goto restart;
}        

/* nmi function */
void nmi()
{
    update_sound();
}
